<?php
require 'config.php';

if (!isset($_GET['id'])) {
    echo "No ID provided.";
    exit;
}

$id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM snips WHERE id = ? AND expires_at > NOW()");
$stmt->execute([$id]);
$snip = $stmt->fetch();

if (!$snip) {
    echo "Snip expired or not found.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>img tool</title>
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <header>
    <h1><a href="index.html">Image Tool</a></h1>
    <button class="dark-toggle" onclick="toggleDark()">🌓</button>
    <script>
  function toggleDark() {
    document.body.classList.toggle('light');
  }
</script>
  </header>

  <div id="preview">
    <img src="uploads/<?= htmlspecialchars($snip['filename']) ?>" alt="Snip">
    <p>Uploaded at: <?= htmlspecialchars($snip['uploaded_at']) ?></p>
    <p>Expires at: <?= htmlspecialchars($snip['expires_at']) ?></p>
  </div>

  <script>
    function toggleDark() {
      document.body.classList.toggle('dark');
    }
  </script>
</body>
</html>
