<?php
require 'config.php';

$upload_dir = "uploads/";
if (!is_dir($upload_dir)) mkdir($upload_dir);

if ($_FILES['image']) {
    $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

    if (!in_array(strtolower($ext), $allowed)) {
        http_response_code(400);
        echo "Unsupported file type.";
        exit;
    }

    $id = substr(md5(uniqid()), 0, 12);
    $filename = $id . "." . $ext;
    $path = $upload_dir . $filename;

    if (move_uploaded_file($_FILES['image']['tmp_name'], $path)) {
        $expires = date('Y-m-d H:i:s', time() + 7 * 24 * 60 * 60); // 7 days from now
        $stmt = $pdo->prepare("INSERT INTO snips (id, filename, original_name, expires_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$id, $filename, $_FILES['image']['name'], $expires]);
        echo "https://practice.stormlight.in/view.php?id=" . $id;
    } else {
        http_response_code(500);
        echo "Upload failed.";
    }
}
